﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM.Maps.SingleMaps;
using Mdws2ORM.Maps.Fields;

namespace Mdws2ORM.Maps.EIS
{
    public class PatientMap : EntityMap<Patient>
    {
        public override string File
        {
            get { return "2"; }
        }

        public override string Location
        {
            get { return "DPT("; }
        }

        class X
        {
            public string a { get; set; }
        }

        protected override void MapFields()
        {
            MapFreeText(".01", (e, value) => e.Name = value);
            MapSetOfCodes(".02", (e, value) => e.Sex = value);
            MapDateTime(".03", (e, value) => e.DateOfBirth = value);
            MapFreeText(".09", (e, value) => e.SocialSecurityNumber = GetSsn(value));            
            MapDateTime(".097", (e, value) => e.DateEnteredIntoFile = value);
            MapPointerToFile<FacilityTreatingSpecialty>(".103", (e, value) => e.TreatingSpecialtyId = value, (e, v) => e.TreatingSpecialty = v);
            MapPointerToFile<NewPerson>(".1041", (e, value) => { }, (e, v) => e.AttendingPhysician = v);
            MapNumericInt(".302", (e, value) => e.ServiceConnectedPercentage = value);
            MapPointerToFileSingle(".105", (e, value) => e.AdmissionIen = value, (e, v) => e.AdmittingDiagnosis = v, SingleMapFactory.MakeStringEntityMap("405", "DGPM(", ".1"));
            //MapBoolean(".109", (e, value) => e.IsOptOut = value);
        }

        private static string GetSsn(string value)
        {
            try
            {
                return value.Insert(3, "-").Insert(6, "-");
            }
            catch
            {
                return value;
            }
        }

        public override Patient NewEntity(string ien)
        {
            return new Patient() { IEN = ien };
        }
    }
}
